# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import PostgreSQLManagementClientConfiguration
from .operations import (
    CheckNameAvailabilityOperations,
    ConfigurationsOperations,
    DatabasesOperations,
    FirewallRulesOperations,
    LocationBasedPerformanceTierOperations,
    LogFilesOperations,
    Operations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    RecoverableServersOperations,
    ReplicasOperations,
    ServerAdministratorsOperations,
    ServerBasedPerformanceTierOperations,
    ServerKeysOperations,
    ServerParametersOperations,
    ServerSecurityAlertPoliciesOperations,
    ServersOperations,
    VirtualNetworkRulesOperations,
)

if TYPE_CHECKING:
    from azure.core import AzureClouds
    from azure.core.credentials_async import AsyncTokenCredential


class PostgreSQLManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """The Azure Database for PostgreSQL management API provides create, read, update, and delete
    functionality for Azure PostgreSQL resources including servers, databases, firewall rules,
    network configuration, security alert policies, log files and configurations with new business
    model.

    :ivar servers: ServersOperations operations
    :vartype servers: azure.mgmt.rdbms.postgresql.aio.operations.ServersOperations
    :ivar replicas: ReplicasOperations operations
    :vartype replicas: azure.mgmt.rdbms.postgresql.aio.operations.ReplicasOperations
    :ivar firewall_rules: FirewallRulesOperations operations
    :vartype firewall_rules: azure.mgmt.rdbms.postgresql.aio.operations.FirewallRulesOperations
    :ivar virtual_network_rules: VirtualNetworkRulesOperations operations
    :vartype virtual_network_rules:
     azure.mgmt.rdbms.postgresql.aio.operations.VirtualNetworkRulesOperations
    :ivar databases: DatabasesOperations operations
    :vartype databases: azure.mgmt.rdbms.postgresql.aio.operations.DatabasesOperations
    :ivar configurations: ConfigurationsOperations operations
    :vartype configurations: azure.mgmt.rdbms.postgresql.aio.operations.ConfigurationsOperations
    :ivar server_parameters: ServerParametersOperations operations
    :vartype server_parameters:
     azure.mgmt.rdbms.postgresql.aio.operations.ServerParametersOperations
    :ivar log_files: LogFilesOperations operations
    :vartype log_files: azure.mgmt.rdbms.postgresql.aio.operations.LogFilesOperations
    :ivar server_administrators: ServerAdministratorsOperations operations
    :vartype server_administrators:
     azure.mgmt.rdbms.postgresql.aio.operations.ServerAdministratorsOperations
    :ivar recoverable_servers: RecoverableServersOperations operations
    :vartype recoverable_servers:
     azure.mgmt.rdbms.postgresql.aio.operations.RecoverableServersOperations
    :ivar server_based_performance_tier: ServerBasedPerformanceTierOperations operations
    :vartype server_based_performance_tier:
     azure.mgmt.rdbms.postgresql.aio.operations.ServerBasedPerformanceTierOperations
    :ivar location_based_performance_tier: LocationBasedPerformanceTierOperations operations
    :vartype location_based_performance_tier:
     azure.mgmt.rdbms.postgresql.aio.operations.LocationBasedPerformanceTierOperations
    :ivar check_name_availability: CheckNameAvailabilityOperations operations
    :vartype check_name_availability:
     azure.mgmt.rdbms.postgresql.aio.operations.CheckNameAvailabilityOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.rdbms.postgresql.aio.operations.Operations
    :ivar server_security_alert_policies: ServerSecurityAlertPoliciesOperations operations
    :vartype server_security_alert_policies:
     azure.mgmt.rdbms.postgresql.aio.operations.ServerSecurityAlertPoliciesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.rdbms.postgresql.aio.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources:
     azure.mgmt.rdbms.postgresql.aio.operations.PrivateLinkResourcesOperations
    :ivar server_keys: ServerKeysOperations operations
    :vartype server_keys: azure.mgmt.rdbms.postgresql.aio.operations.ServerKeysOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword cloud_setting: The cloud setting for which to get the ARM endpoint. Default value is
     None.
    :paramtype cloud_setting: ~azure.core.AzureClouds
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        *,
        cloud_setting: Optional["AzureClouds"] = None,
        **kwargs: Any
    ) -> None:
        _cloud = cloud_setting or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = PostgreSQLManagementClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            cloud_setting=cloud_setting,
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.servers = ServersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.replicas = ReplicasOperations(self._client, self._config, self._serialize, self._deserialize)
        self.firewall_rules = FirewallRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_network_rules = VirtualNetworkRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.databases = DatabasesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.configurations = ConfigurationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.server_parameters = ServerParametersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.log_files = LogFilesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.server_administrators = ServerAdministratorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.recoverable_servers = RecoverableServersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.server_based_performance_tier = ServerBasedPerformanceTierOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.location_based_performance_tier = LocationBasedPerformanceTierOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.check_name_availability = CheckNameAvailabilityOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.server_security_alert_policies = ServerSecurityAlertPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.server_keys = ServerKeysOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
